	{* Latest issue *}
	<div class="issue_selection">

	  <!-- Nav tabs -->
	  <ul class="nav nav-tabs" role="tablist">
	    {if ($prevArticles && $isEnablePreviousIssue)}
  	    <li role="presentation"><a href="#previous_issue" aria-controls="previous_issue" role="tab" data-toggle="tab"><i
  	          class="fa fa-reply"> </i> {translate key="journal.previousIssue"} </a></li>
	    {/if}
	    <li role="presentation" class="active"><a href="#current_issue" aria-controls="current_issue" role="tab"
	        data-toggle="tab"><i class="fa fa-bookmark-o"> </i> {translate key="journal.currentIssue"}</a></li>
	    {if ($futureIssue && $isEnableUpcomingIssue)}
  	    <li role="presentation"><a href="#future_issue" aria-controls="future_issue" role="tab" data-toggle="tab"><i
  	          class="fa fa-calendar-o"> </i> {translate key="journal.upcomingIssue"}</a></li>
	    {/if}

	  </ul>

	  <!-- Tab panes -->
	  <div class="tab-content issue_selected_tab">
	    {if ($prevArticles && $isEnablePreviousIssue)}
  	    <div role="tabpanel" class="tab-pane fade" id="previous_issue">

  	      <div class="issue_identification row alert alert-grey mb-2">

  	        <div class="col-md-1 pt-3 mr-2">
  	          <i class="fa fa-book fa-4" aria-hidden="true"></i>
  	        </div>

  	        {assign var=date value=$prevIssue->getDatePublished()|strtotime}
  	        <div class="col-md-10">
  	          <div class="col-md-12">{$prevIssue->getLocalizedTitle()} </div>
  	          <div class="col-md-12"> Volume {$prevIssue->getVolume()}, Number : {$prevIssue->getNumber()} </div>
  	          <div class="col-md-12"> <i class="fa fa-calendar"> </i> {$date|date_format:"%B %e, %Y"} </div>
  	        </div>

  	      </div>


  	      <div class="prev_article_list row ">

  	        {if $prevIssue->getLocalizedDescription()}
    	        <div class="col-md-12 mt-4 issue_description"> Issue Description </div>
    	        <div class="col-md-12 mb-4">{$prevIssue->getLocalizedDescription()} </div>
  	        {/if}



  	        {assign var="section_title" value=''}
  	        {foreach from=$prevArticles item=article}
    	        {if $section_title != $article.section_title}
      	        {assign var="section_title" value=$article.section_title}
      	        <h5 class="mt-4 mb-0 pt-2 px-4"> {$article.section_title} </h5>
    	        {/if}

    	        {include file="frontend/objects/article_list.tpl"}
  	        {/foreach}
  	      </div>

  	    </div>

	    {/if}


	    <div role="tabpanel" class="tab-pane fade in active pt-4" id="current_issue">Current Issue</div>

	    {* Future Issue *}
	    {if ($futureIssue && $isEnableUpcomingIssue)}
  	    <div role="tabpanel" class="tab-pane fade in " id="future_issue">

  	      <div class="issue_identification row alert alert-grey mb-2">

  	        <div class="col-md-1 pt-3 mr-2">
  	          <i class="fa fa-book fa-4" aria-hidden="true"></i>
  	        </div>

  	        <div class="col-md-10">
  	          <div class="col-md-12 title pt-3">{$futureIssue->getLocalizedTitle()} </div>
  	          <div class="col-md-12 mb-4"> Volume {$futureIssue->getVolume()}, Number :
  	            {$futureIssue->getNumber()} </div>
  	        </div>
  	      </div>

  	      {if $futureIssue->getLocalizedDescription()}
    	      <div class="col-md-12 mt-4 no-padding issue_description"> Issue Description </div>
    	      <div class="col-md-12 no-padding mb-4">{$futureIssue->getLocalizedDescription()} </div>
  	      {/if}

  	      <div class="future_article_list row ">
  	        {foreach from=$futureArticles item=article}
    	        {include file="frontend/objects/article_list.tpl"}
  	        {/foreach}
  	      </div>
  	    </div>
	    {/if}

	    {* end future issue section *}

</div>