{**
 * templates/frontend/pages/article.tpl
 *
 * Copyright (c) 2010-2020 openjournaltheme.com 
 * Copyright (c) 2010-2020 openjournaltheme team
 * Read this term of use of this theme here : https://openjournaltheme.com/term-of-conditions
 *
 * @brief Display the page to view an article with all of it's details.
 *
 * @uses $article Article This article
 * @uses $issue Issue The issue this article is assigned to
 * @uses $section Section The journal section this article is assigned to
 * @uses $journal Journal The journal currently being viewed.
 * @uses $primaryGalleys array List of article galleys that are not supplementary or dependent
 * @uses $supplementaryGalleys array List of article galleys that are supplementary
 *}

{*Catch the author or article  *}
{capture assign="authorName"}{foreach from=$article->getAuthors() item=author}{if $author->getFullName()}{$author->getFullName()|escape},{/if}{/foreach}{/capture}

{* {include file="frontend/components/header.tpl" isFullWidth=true authorName=$authorName|escape pageTitleTranslated=$article->getLocalizedTitle()|escape|strip_tags description=$article->getLocalizedAbstract()|escape|strip_tags } *}
{include file="frontend/components/articleHeader.tpl" isFullWidth=true authorName=$authorName|escape pageTitleTranslated=$article->getLocalizedTitle()|escape|strip_tags description=$article->getLocalizedAbstract()|escape|strip_tags }




<div class="page page_article">


	{* Show article overview *}
	{* {include file="frontend/objects/article_details.tpl"} *}

	{include file="frontend/objects/article_detailsTwo.tpl"}	

	{call_hook name="Templates::Article::Footer::PageFooter"}

</div><!-- .page -->

{include file="frontend/components/footer.tpl" isFullWidth=true}
