{**
 * templates/frontend/components/footer.tpl
 *
  * Copyright (c) 2010-2020 openjournaltheme.com 
 * Copyright (c) 2010-2020 openjournaltheme team
 * Read this term of use of this theme here : https://openjournaltheme.com/term-of-conditions
 *
 * @brief Common site frontend footer.
 *
 * @uses $isFullWidth bool Should this page be displayed without sidebars? This
 *       represents a page-level override, and doesn't indicate whether or not
 *       sidebars have been configured for thesite.
* @uses $currentContext Journal|Press The current journal or press
* @uses $about 
 * @uses $mailingAddress string Mailing address for the journal/press
 * @uses $contactName string Primary contact name
 * @uses $contactTitle string Primary contact title
 * @uses $contactAffiliation string Primary contact affiliation
 * @uses $contactPhone string Primary contact phone number
 * @uses $contactEmail string Primary contact email address
 * @uses $supportName string Support contact name
 * @uses $supportPhone string Support contact phone number
 * @uses $supportEmail string Support contact email address
 *}

	</main>



	{* Sidebars *}
	{if empty($isFullWidth) && empty($jatsResult)}
		{capture assign="sidebarCode"}{call_hook name="Templates::Common::Sidebar"}{/capture}
		
		{if $sidebarCode}
			<aside id="sidebar" class="pkp_structure_sidebar left col-xs-12 col-sm-5 col-md-4" role="complementary" aria-label="{translate|escape key="common.navigation.sidebar"}">
				{$sidebarCode}			
			</aside><!-- pkp_sidebar.left -->
		{/if}	
	{/if}
	</div><!-- pkp_structure_content -->

	{* static page for academic proextended mode *}
	{if $isExtendedMode}
	{capture assign="sidebarCode"}{call_hook name="Templates::Common::Sidebar"}{/capture}		
		{if $sidebarCode}
			<aside id="sidebar"  style="display:none">
				{$sidebarCode}			
			</aside><!-- pkp_sidebar.left -->
		{/if}
	{/if}

	

	<div class="container list_of_index">
		<div class="col-md-12 indexed_by hidden">
		
		</div>
	</div>


	<div class="footer_border"></div>
	<footer id="footer" class="footer" role="contentinfo">
		



		<div class="container-fluid no-padding-left no-padding-right">

			
				
				{* Show site Logo *}
				{* <div class="col-md-4">
					
					{if $displayPageHeaderLogo && is_array($displayPageHeaderLogo)}
					<img style='width:100%; border="0"' src="{$publicFilesDir}/{$displayPageHeaderLogo.uploadName|escape:"url"}" {if $displayPageHeaderLogo.altText != ''}alt="{$displayPageHeaderLogo.altText|escape}"{else}alt="{translate key="common.pageHeaderLogo.altText"}"{/if}>
					{else}
						<img  style='width:100%; border="1px solid #e5e5e5"; border-radius: 4px;' alt="site_logo" src="{$pluginImageDir}top_logo.jpg" /> 
					{/if}
				
				</div>
				 *}

			
				
				{if $pageFooter}
					{$pageFooter}
				{/if}

				
				
			

			<span class="hidden"> Ver 1.4 : openjournaltheme.com </span>
			
			{if $alertValidated}
				{$alertValidated}
			{/if}


		</div><!-- .container -->
	</footer>
</div><!-- pkp_structure_page -->

{load_script context="frontend" scripts=$scripts}

{call_hook name="Templates::Common::Footer::PageFooter"}
</body>
</html>
