{**
 * templates/common/formErrors.tpl
 *
 * Copyright (c) 2010-2020 openjournaltheme.com 
 * Copyright (c) 2010-2020 openjournaltheme team
 * Read this term of use of this theme here : https://openjournaltheme.com/term-of-conditions/
 * Modify, redistribute or make commercial copy of this part or whole of this code is prohibited without written permission from openjournaltheme.com
 *
 * @brief List errors that occurred during form processing.
 *
 * @uses $isError bool If an error exists
 * @uses $errors array List of error messages
 *}
{if $isError}
	<div class="alert alert-danger">
		<h4>
			{translate key="form.errorsOccurred"}
		</h4>
		<ul class="pkp_form_error_list">
			{foreach key=field item=message from=$errors}
				<li>
					<a href="#{$field|escape}">{$message}</a>
				</li>
			{/foreach}
		</ul>
	</div>
	<script>{literal}
		<!--
		// Jump to form errors.
		window.location.hash="formErrors";
		// -->
	{/literal}</script>
{/if}
