<?php
import('classes.handler.Handler');

class AcademicProHandler extends Handler
{

    public $pluginName = 'academicProThemePlugin';
    public $_plugin;

    public function __construct()
    {
        $this->_setPlugin();
    }

    private function _getPlugin($pluginName, $type)
    {
        return PluginRegistry::getPlugin($type, $pluginName);
    }

    private function _setPlugin(): Void
    {
        $this->_plugin = $this->_getPlugin($this->pluginName, 'themes');

        if (is_null($this->_plugin)) {
            $this->_plugin = $this->_getPlugin(strtolower($this->pluginName), 'themes');
        }
    }

    function validate_now()
    {
        header('Access-Control-Allow-Origin: *'); //allow cors
        header('Access-Control-Allow-Headers: x-csrf-uap-admin-token');
        echo $this->_plugin->validate_now();
    }

    function check_now()
    {
        header('Access-Control-Allow-Origin: *'); //allow cors
        header('Access-Control-Allow-Headers: x-csrf-uap-admin-token');
        echo $this->_plugin->check_now();
    }

    function dev_cp($args)
    {
        $args[1] = $args[0];
        require_once __DIR__ . '/templates/legacy/creditNote.php';
        $openJournalTheme = $this->_plugin->openJournalThemeInit();
        $style = "display:none;";
        if ($xkcI) {
            $openJournalTheme->handleCp();
            $style = $xkcI ? '' : $style;
        }
        $isInstalled = ($openJournalTheme->isCurlInstalled()) ? 'Installed' : 'Not found';
        echo sprintf('<span id="curl_status" style="' . $style . '">Curl is %s</span>', $isInstalled);
        exit;
    }
}
