
{include file="frontend/components/header.tpl" pageTitleTranslated=$article->getLocalizedTitle()|escape}

<div class="page page_article_galley">
	{if $section}
		{include file="frontend/components/breadcrumbs_article.tpl" currentTitle=$section->getLocalizedTitle()}
	{else}
		{include file="frontend/components/breadcrumbs_article.tpl" currentTitleKey="common.publication"}
	{/if}
  <article class="obj_article_details">

    {* Indicate if this is only a preview *}
    {if $publication->getData('status') !== $smarty.const.STATUS_PUBLISHED}
    <div class="cmp_notification notice">
      {capture assign="submissionUrl"}{url page="workflow" op="access" path=$article->getId()}{/capture}
      {translate key="submission.viewingPreview" url=$submissionUrl}
    </div>
    {* Notification that this is an old version *}
    {elseif $currentPublication->getId() !== $publication->getId()}
      <div class="cmp_notification notice">
        {capture assign="latestVersionUrl"}{url page="article" op="view" path=$article->getBestId()}{/capture}
        {translate key="submission.outdatedVersion"
          datePublished=$publication->getData('datePublished')|date_format:$dateFormatShort
          urlRecentVersion=$latestVersionUrl|escape
        }
      </div>
    {/if}

    <h1 class="page_title">
      {$publication->getLocalizedTitle()|escape}
    </h1>

    {if $publication->getLocalizedData('subtitle')}
      <h2 class="subtitle">
        {$publication->getLocalizedData('subtitle')|escape}
      </h2>
    {/if}

    <div class="item ojt-jats-parser">
      {$htmlDocument}
    </div>
  </article>


</div><!-- .page -->

{include file="frontend/components/footer.tpl"}
<script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
<script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>