<?php
/* Copyright (c) 2010-2020 openjournaltheme.com
    Copyright (c) 2010-2020 openjournaltheme team
    Read this term of use of this theme here : https://openjournaltheme.com/term-of-conditions/
    Modify, redistribute or make commercial copy of this part or whole of this code is prohibited without written permission from openjournaltheme.com
*/

if (!class_exists('\AcademicExtended\OpenJournalTheme')) {
    require_once __DIR__ . '/../include/Core.php';
}

use AcademicExtended\OpenJournalTheme;

const VIEW_ABSTRACT_COUNT = '1048585';

import('lib.pkp.classes.plugins.ThemePlugin');

class AcademicProThemeExtended33 extends ThemePlugin
{

    public function check_now()
    {
        $post = (object) $_POST;
        $openJournalTheme = $this->openJournalThemeInit();
        if (!$openJournalTheme->isFromLocal()) {
            $openJournalTheme->checkNow($post->hash);
            return $openJournalTheme->getStatusValidated();
        }
        return 1;
    }

    public function getPluginName()
    {
        return strtolower(__CLASS__);
    }

    public function validate_now()
    {
        $license = $_POST['license'];
        $key = $_POST['hash'];
        $openJournalTheme = $this->openJournalThemeInit();
        if ($openJournalTheme->authHash($key) && $openJournalTheme->isFromLocal()) {
            $openJournalTheme->updateSetting('license', $license);
            $openJournalTheme->saveOption('licenseMain', $license);
            $openJournalTheme->validate();
            return $openJournalTheme->getStatusValidated();
        }
        return 1;
    }

    /**
     * @return object OpenJournalValidation object
     */
    public function openJournalThemeInit()
    {
        return new OpenJournalTheme($this, true);
    }

    public function setPageHandler($hookName, $params)
    {
        $page = $params[0];
        if ($page == $this->getPluginName()) {
            $this->import('AcademicProExtendedHandler');
            define('HANDLER_CLASS', 'AcademicProExtendedHandler');
            return true;
        }
        return false;
    }

    function register($category, $path, $mainContextId = null)
    {
        if (!parent::register($category, $path, $mainContextId)) return false;

        // Don't perform any futher operations if theme is not currently active
        if (!$this->isActive()) {
            return true;
        }

        HookRegistry::register('TemplateManager::display', [$this, 'loadTemplateDataExtended']);
        HookRegistry::register('LoadHandler', [$this, 'setPageHandler']);
        HookRegistry::register('TemplateManager::display', [$this, 'addHeaderMeta']);


        return true;
    }

    public function addHeaderMeta($hookName, $args)
    {
        $templateMgr            = &$args[0];
        $templateMgr->addHeader(
            $this->getName(),
            '<meta name="' . $this->getName() . '" content="' . $this->getDisplayName() . ' Version ' . $this->getPluginVersion() . ' by openjournaltheme.com">',
            [
                'contexts' => ['frontend'],
            ]
        );
    }

    public function getPluginVersion()
    {
        import('lib.pkp.classes.site.VersionCheck');
        $version = VersionCheck::parseVersionXML($this->getPluginVersionFile());

        return $version['release'];
    }

    public function getPluginVersionFile()
    {
        return $this->getPluginPath() . '/version.xml';
    }


    /**
     * Initialize the theme's styles, scripts and hooks. This is only run for
     * the currently active theme.
     *
     * @return null
     */
    public function init()
    {
        //$this->setParent('academicprothemeplugin');


        $this->setParent('academicprothemeplugin');

        // Libraries
        $this->addStyle('swiper', 'packages/swiper/swiper.min.css');
        $this->addScript('swiper', 'packages/swiper/swiper.min.js');

        $this->addStyle('default', 'styles/academic_pro_extended.css');
        $this->addScript('default', 'js/academic_pro_extended.js');

        //view credit to openjournaltheme.com
        // register the method so it can be accessed

        // show the previous tab
        $this->addOption('isEnablePreviousIssue', 'radio', [
            'label'       => 'isEnablePreviousIssue',
            'description' => 'isEnablePreviousIssue.description',
            'options'     => [
                'yes' => 'plugins.themes.academic_pro.enable',
                'no'  => 'plugins.themes.academic_pro.disable',
            ],
            'default'     => 'yes',
        ]);

        // show the future / upcoming tab
        $this->addOption('isEnableUpcomingIssue', 'radio', [
            'label'       => 'isEnableUpcomingIssue',
            'description' => 'isEnablePreviousIssue.description',
            'options'     => [
                'yes' => 'plugins.themes.academic_pro.enable',
                'no'  => 'plugins.themes.academic_pro.disable',
            ],
            'default'     => 'yes',
        ]);

        // license
        $this->addOption('licenseMain', 'text', [
            'label'       => 'plugins.themes.academic_pro.licensi_label',
            'description' => 'plugins.themes.academic_pro.licensi_description',
            'default'     => null,
        ]);
    }

    /**
     * Get the display name of this plugin
     * @return string
     */
    public function getDisplayName()
    {
        return 'Academic Pro Extended Theme';
    }

    /**
     * Get the description of this plugin
     * @return string
     */
    public function getDescription()
    {
        return 'Academic Pro Extended Features - Academic Pro child theme (read academic pro theme manual)';
    }

    /**
     * Fired when the `TemplateManager::display` hook is called.
     *
     * @param string $hookname
     * @param array $args [$templateMgr, $template, $sendContentType, $charset, $output]
     */
    public function loadTemplateDataExtended($hookName, $args)
    {
        $paths = explode('/', $args[1]);

        // only process when template file name is indexJournal.tpl
        if (!in_array("indexJournal.tpl", $paths)) {
            return;
        }


        $templateMgr = $args[0];
        $ojt         = $this->openJournalThemeInit();
        if (!$ojt->isFromLocal() && $this->isActive() && !$ojt->isMainIndexPage()) {
            $ojt->main();
            if (!$ojt->isNotDomain()) {
                if ($ojt->getStatusValidated() == 2) {
                    $templateMgr->assign('prevent', $ojt->prevent());
                }
                $templateMgr->assign('alertValidated', $ojt->getHtml());
            }
        }

        //tab option (previous and future / upcoming) issue
        $isEnablePreviousIssue = ($this->getOption('isEnablePreviousIssue') == 'no') ? false : true;
        $templateMgr->assign('isEnablePreviousIssue', $isEnablePreviousIssue);

        $isEnableUpcomingIssue = ($this->getOption('isEnableUpcomingIssue') == 'no') ? false : true;
        $templateMgr->assign('isEnableUpcomingIssue', $isEnableUpcomingIssue);

        $issueDao            = DAORegistry::getDAO('IssueDAO');
        //prev Issue Identification
        $prevIssueID = $this->getPrevIssueID();
        $prevIssue   =  $issueDao->getById($prevIssueID);
        $templateMgr->assign('prevIssue', $prevIssue);
        $templateMgr->assign('prevArticles', $this->getPreviousIssueArticleList());

        //future issue section will show article although it is not published

        $futureIssueID = $this->getFutureIssueID();
        $futureIssue   =  $issueDao->getById($futureIssueID);
        $templateMgr->assign('futureIssue', $futureIssue);
        $templateMgr->assign('futureArticles', $this->getFutureIssueArticleList());
    }

    private function getPrevIssueID()
    {
        $issueDao            = DAORegistry::getDAO('IssueDAO');

        $context_id          = $this->getCurrentContextId();
        if (!$context_id) {
            return false;
        }

        $currentIssueId = $this->getCurrentIssueID();

        if (!$currentIssueId) {
            return false;
        }

        $prevIssue = $issueDao->retrieve(
            "SELECT issue_id FROM issues where current != 1 and published = 1 and journal_id = $context_id and issue_id < $currentIssueId  ORDER BY issue_id DESC LIMIT 1"
        );

        // var_dump($prevIssue->fields['issue_id']);
        //$prevIssueId = $prevIssue->fields['issue_id'];

        return $prevIssue->current()->issue_id;
    }

    public function getPreviousIssueArticleList()
    {
        $publishedArticleDao = DAORegistry::getDAO('SubmissionDAO');
        $galleyDao           = DAORegistry::getDAO('ArticleGalleyDAO');
        $request             = $this->getRequest();
        $context             = $request->getContext();

        $prevIssueId = $this->getPrevIssueID();

        if (!$prevIssueId) {
            return;
        }

        $query = "SELECT p.submission_id, p.publication_id
            FROM submissions s
            LEFT JOIN publications p ON (p.publication_id = s.current_publication_id)
            LEFT JOIN publication_settings ps ON (ps.publication_id = p.publication_id)
            WHERE ps.setting_name = 'issueId' AND ps.setting_value = $prevIssueId ORDER BY seq ASC";

        $result = $publishedArticleDao->retrieve(
            $query
        );

        for ($i = 1; $submission = (array) $result->current(); $i++) {
            // $resultRow  = $submission->GetRowAssoc(false);
            $submission_id  = $submission['submission_id'];
            $publication_id = $submission['publication_id'];

            $article    = $publishedArticleDao->getById($submission_id);

            $galleyList = $galleyDao->getByPublicationId($publication_id);

            $metricCount = $publishedArticleDao->retrieve(
                "SELECT count(metric) as metric FROM  metrics WHERE submission_id = $submission_id  AND assoc_type =  " . VIEW_ABSTRACT_COUNT . ' LIMIT 1'
            );

            $metric = ($metricCount->current()->metric) ?: 0;

            $articles[$submission_id]['journalPath']   = $context->getPath();
            $articles[$submission_id]['articleId']     = $article->getId();
            $articles[$submission_id]['articleTitle']  = $article->getLocalizedTitle();
            $articles[$submission_id]['subtitle']      = $article->getLocalizedSubtitle();
            $articles[$submission_id]['page']          = $article->getPages();
            $articles[$submission_id]['datePublished'] = $article->getDatePublished();
            $articles[$submission_id]['author']        = $article->getAuthorString();
            $articles[$submission_id]['section_title'] = method_exists($article, 'getSectionTitle') ? $article->getSectionTitle() : '';
            $articles[$submission_id]['metric']        = $metric;
            $articles[$submission_id]['isExistGalley'] = ($galleyList) ? true : false;
            $articles[$submission_id]['doi']           = isset($article->_data['pub-id::doi']) ? $article->_data['pub-id::doi'] : '';

            $n = 0;
            foreach ($article->getGalleys() as $galley_item) {
                $articles[$submission['submission_id']]['galleys'][$n]['label'] = $galley_item->_data['label'];
                $articles[$submission['submission_id']]['galleys'][$n]['id']    = $galley_item->_data['id'];
                $n++;
            }
            $articles[$submission['submission_id']]['galley_count'] = $n;

            $result->next();
        }

        //var_dump($articles);

        return $articles;
    }

    //this will get the last of future issue although it is not published
    private function getFutureIssueID()
    {
        $issueDao            = DAORegistry::getDAO('IssueDAO');
        $context_id          = $this->getCurrentContextId();

        if (!$context_id) {
            return false;
        }

        $currentIssueId = $this->getCurrentIssueID();

        if (!$currentIssueId) {
            return false;
        }

        //unfortunately there is no order / seq column on the issue table, so it will get the latest one from the record
        $futureIssue = $issueDao->retrieve(
            "SELECT issue_id FROM issues where current != 1 and issue_id > $currentIssueId and journal_id = $context_id ORDER BY issue_id DESC LIMIT 1"
        );

        return $futureIssue->current()->issue_id;
    }

    private function getFutureIssueArticleList()
    {
        $publishedArticleDao = DAORegistry::getDAO('SubmissionDAO');
        $galleyDao           = DAORegistry::getDAO('ArticleGalleyDAO');
        $request             = $this->getRequest();
        $context             = $request->getContext();

        $futureIssueId = $this->getFutureIssueID();

        if (!$futureIssueId) {
            return;
        }

        $query = "SELECT p.submission_id, p.publication_id
            FROM submissions s
            LEFT JOIN publications p ON (p.publication_id = s.current_publication_id)
            LEFT JOIN publication_settings ps ON (ps.publication_id = p.publication_id)
            WHERE ps.setting_name = 'issueId' AND ps.setting_value = $futureIssueId ORDER BY seq ASC";

        $result = $publishedArticleDao->retrieve(
            $query
        );

        for ($i = 1; $submission = (array) $result->current(); $i++) {
            // $resultRow  = $submission->GetRowAssoc(false);
            $submission_id  = $submission['submission_id'];
            $publication_id = $submission['publication_id'];

            $article    = $publishedArticleDao->getById($submission_id);

            $galleyList = $galleyDao->getByPublicationId($publication_id);

            $metricCount = $publishedArticleDao->retrieve(
                "SELECT count(metric) as metric FROM  metrics WHERE submission_id = $submission_id  AND assoc_type =  " . VIEW_ABSTRACT_COUNT . ' LIMIT 1'
            );

            $metric = ($metricCount->current()->metric) ?: 0;

            $articles[$submission_id]['journalPath']   = $context->getPath();
            $articles[$submission_id]['articleId']     = $article->getId();
            $articles[$submission_id]['articleTitle']  = $article->getLocalizedTitle();
            $articles[$submission_id]['subtitle']      = $article->getLocalizedSubtitle();
            $articles[$submission_id]['page']          = $article->getPages();
            $articles[$submission_id]['datePublished'] = $article->getDatePublished();
            $articles[$submission_id]['author']        = $article->getAuthorString();
            $articles[$submission_id]['metric']        = $metric;
            $articles[$submission_id]['isExistGalley'] = ($galleyList) ? true : false;
            $articles[$submission_id]['doi']           = $article->_data['pub-id::doi'] ?? '';

            $n = 0;
            foreach ($article->getGalleys() as $galley_item) {
                $articles[$submission['submission_id']]['galleys'][$n]['label'] = $galley_item->_data['label'];
                $articles[$submission['submission_id']]['galleys'][$n]['id']    = $galley_item->_data['id'];
                $n++;
            }
            $articles[$submission['submission_id']]['galley_count'] = $n;

            $result->next();
        }

        return $articles;
    }

    private function getCurrentIssueID()
    {
        $issueDao            = DAORegistry::getDAO('IssueDAO');
        $contextId            = $this->getCurrentContextId();
        if (!$contextId) return false;

        $currentIssue        = $issueDao->getCurrent($contextId);
        return is_null($currentIssue) ? false : $currentIssue->getId();
    }

    private function getVersionNumber()
    {
        $versionDao = DAORegistry::getDAO('VersionDAO');
        $version    = $versionDao->getCurrentVersion();
        $data       = $version->_data;
        return $data['major'] . $data['minor'];
    }

    private function vd($data)
    {
        echo '<pre>';
        var_dump($data);
        echo '</pre>';
        exit;
    }
}
