{**
 * templates/frontend/objects/article_summary.tpl
 *
  * Copyright (c) 2010-2020 openjournaltheme.com 
 * Copyright (c) 2010-2020 openjournaltheme team
 * Read this term of use of this theme here : https://openjournaltheme.com/term-of-conditions
 *
 * @brief View of an Article summary which is shown within a list of articles.
 *
 * @uses $article Article The article
 * @uses $hasAccess bool Can this user access galleys for this context? The
 *       context may be an issue or an article
 * @uses $showGalleyLinks bool Show galley links to users without access?
 * @uses $hideGalleys bool Hide the article galleys for this article?
 * @uses $primaryGenreIds array List of file genre ids for primary file types
 *}

{* smarty 2 does not support tenary *}
{* {assign var=journal_path value=($journal) ? $journal->getPath() : $journal->getPath()} *}

{* 
  Coding asli dari article_summary tidak konsisten untuk currentContext dan currentJournal, jadi digabungkan menjadi 1 variable kedalam $journal
*}
{if !$journal}
  {if $currentContext}
    {assign var=journal value=$currentContext}
  {elseif $currentJournal}
    {assign var=journal value=$currentJournal}
  {/if}
{/if}


{assign var=journal_path value=$journal->getPath()}


{assign var=smarty_version value=$smarty.version|substr:0:1}
{assign var=articlePath value=$article->getBestArticleId($journal)}
{if (!$section.hideAuthor && $article->getHideAuthor() == $smarty.const.AUTHOR_TOC_DEFAULT) || $article->getHideAuthor() == $smarty.const.AUTHOR_TOC_SHOW}
  {assign var="showAuthor" value=true}
{/if}

{if $requestedPage || $requestedPage == 'index'}
  {assign var="indexPage" value=true}
{/if}
{assign var=publication value=$article->getCurrentPublication()}

<div class="article-summary media">
  {foreach from=$article->getGalleys() item=galley}
    {assign var="hasArticleAccess" value=$hasAccess}
    {if $journal->getSetting('publishingMode') == $smarty.const.PUBLISHING_MODE_OPEN || $publication->getData('accessStatus') == $smarty.const.ARTICLE_ACCESS_OPEN}
      {assign var="hasArticleAccess" value=1}
    {/if}

    {if $galley->getGalleyLabel()|escape|lower == 'video'}
      {$galley->getFile()}
    {/if}

  {/foreach}



  {if $article->getLocalizedCoverImage()}
    <div class="cover media-left">
      <a href="{url  journal=$journal_path page="article" op="view" path=$articlePath}" class="file">
        <img class="media-object" src="{$article->getLocalizedCoverImageUrl()|escape}">
      </a>
    </div>
  {/if}

  <div class="media-body article_summary">
    <h3 class="media-heading">
      <a href="{url  journal=$journal_path page="article" op="view" path=$articlePath}" class="article_name">
        {$article->getLocalizedTitle()|strip_unsafe_html}
        {if $article->getLocalizedSubtitle()}
          <p>
            <small>{$article->getLocalizedSubtitle()|escape}</small>
          </p>
        {/if}
      </a>
    </h3>


    <div class="meta row">

      {* {assign var=doi value=$article->_data['pub-id::doi']}	 *}
      {assign var=doi  value=$article->_data['publications'][0]->_data['pub-id::doi']}

      {if $showDoiOnIndex}

        {if !$doi }
          {foreach from=$pubIdPlugins item=pubIdPlugin}
            {if $issue->getPublished()}
              {assign var=pubId value=$article->getStoredPubId($pubIdPlugin->getPubIdType())}
            {else}
              {assign var=pubId value=$pubIdPlugin->getPubId($article)}{* Preview pubId *}
            {/if}
            {if $pubId}
              {assign var="doi" value=$pubIdPlugin->getResolvingURL($journal->getId(), $pubId)|replace:'https://doi.org/':''}
            {/if}
          {/foreach}
        {/if}

        {if $doi }
          <div class="col-md-12 col-xs-12 journal_index_doi">
            <span class="doi_logo"> </span>
            <a href="{url page="article" op="view" path=$articlePath}" class="doi_link">
              {$doi}
            </a>
          </div>
        {/if}

      {/if}

      <div class="col-md-12 col-xs-12">

        {if $showAuthor && $activeTheme->getOption('author_affiliation')}
          <div class="author">
            <span>
              <i class="fa fa-users"> </i>
              {foreach from=$publication->getData('authors') item=author}
                {$author->getFullName()}
                <sup>({$author@iteration})</sup>{if $author@iteration !== $publication->getData('authors')|@count},{/if}
              {/foreach}
            </span>
            <div class="author_affiliation">
              {foreach from=$publication->getData('authors') item=author}
                <div>
                  ({$author@iteration})
                  {$author->getLocalizedData('affiliation')}
                  {if $author@iteration !== $publication->getData('authors')|@count},
                  {/if}

                </div>
              {/foreach}
            </div>
          </div>
        {/if}
        {if $article->getPages()}
          <span class="pull-left pages">
            <i class="fa fa-file-text-o" aria-hidden="true"></i> <span class="page_number"> {$article->getPages()|escape}
            </span>
          </span>
        {/if}
        {if $showAuthor && !$activeTheme->getOption('author_affiliation')}
          <span class="pull-right author">
            <span><i class="fa fa-users"> </i> {$article->getAuthorString()|escape} </span>
          </span>
        {/if}

      </div>
    </div>
  </div>


  {if $article->getGalleys()}
    <div class="row">
      <div class="col-md-8 col-xs-12">

        {foreach from=$article->getGalleys() item=galley}
          {if $primaryGenreIds}
            {assign var="file" value=$galley->getFile()}
            {if !$galley->getRemoteUrl() && !($file && in_array($file->getGenreId(), $primaryGenreIds))}
              {continue}
            {/if}
          {/if}

          {include file="frontend/objects/galley_link.tpl" parent=$article hasAccess=$hasArticleAccess}
        {/foreach}

      </div>


      {if $enableStatistic}
        <div class="col-md-4 col-xs-12 stat_counter"> <span class="article_counter_read"></span> <span class="hidden-xs">
            {translate key="journal.read_statistic"}:</span> {$article->getViews()} </div>
      {/if}

    </div>
  {/if}

  {call_hook name="Templates::Issue::Issue::Article"}
</div><!-- .article-summary -->