{**
 * templates/frontend/objects/article_details.tpl
 *
  * Copyright (c) 2010-2020 openjournaltheme.com 
 * Copyright (c) 2010-2020 openjournaltheme team
 * Read this term of use of this theme here : https://openjournaltheme.com/term-of-conditions
 *
 * @brief View of an Article which displays all details about the article.
 *  Expected to be primary object on the page.
 *
 * @uses $article Article This article
 * @uses $issue Issue The issue this article is assigned to
 * @uses $section Section The journal section this article is assigned to
 * @uses $keywords array List of keywords assigned to this article
 * @uses $citationFactory @todo
 * @uses $pubIdPlugins @todo
 *}



{assign var=smarty_version value=$smarty.version|substr:0:1}

<article class="article-details">


	<div class="row">


		<section class="article-sidebar col-md-4">

			{* Screen-reader heading for easier navigation jumps *}
			<h2 class="sr-only">{translate key="plugins.themes.academic_pro.article.sidebar"}</h2>

			{* Article/Issue cover image *}
			{if $article->getLocalizedCoverImage() || $issue->getLocalizedCoverImage()}
				<div class="cover-image">
					{if $article->getLocalizedCoverImage()}
						<img class="img-responsive" src="{$article->getLocalizedCoverImageUrl()|escape}"
							{if $article->getLocalizedCoverImageAltText()} alt="{$article->getLocalizedCoverImageAltText()|escape}" {/if}>
					{else}
						<a href="{url page="issue" op="view" path=$issue->getBestIssueId()}">
							<img class="img-responsive" src="{$issue->getLocalizedCoverImageUrl()|escape}"
								{if $issue->getLocalizedCoverImageAltText()} alt="{$issue->getLocalizedCoverImageAltText()|escape}" {/if}>
						</a>
					{/if}
				</div>
			{/if}





			<div class="list-group">

				{* Published date *}
				{if $article->getDatePublished() && $articleTrackingDate}
					<div class="row date-list">

						<div class="col-md-12 detail">
							{if ($journalVersion >= '33')}
								<strong>{translate key="submissions.submitted"}</strong>
								<div class="date">{$article->getDateSubmitted()|date_format:$dateFormatLong}</div>
							</div>

							{if $acceptanceDate}
								<div class="col-md-12 detail">
									<strong>{translate key="submissions.accepted"}</strong>
									<div class="date">{$acceptanceDate|date_format:$dateFormatLong}</div>
								</div>
							{/if}

							<div class="col-md-12 detail">
								<strong>{translate key="submissions.published"}</strong>
								<div class="date">{$article->getDatePublished()|date_format:$dateFormatLong}</div>
							{else}
								<strong>{translate key="submissions.submitted"}</strong>
								<div class="date">{$article->getDateSubmitted()|date_format}</div>
							</div>

							{if $acceptanceDate}
								<div class="col-md-12 detail">
									<strong>{translate key="submissions.accepted"}</strong>
									<div class="date">{$acceptanceDate|date_format}</div>
								</div>
							{/if}

							<div class="col-md-12 detail">
								<strong>{translate key="submissions.published"}</strong>
								<div class="date">{$article->getDatePublished()|date_format}</div>
							{/if}
						</div>


					</div>
				{/if}




			</div>


			{* Galleys *}
			<div class="panel panel-default galley_list">
				<div class="panel-heading">
					<i class="fa fa-download"> </i> {translate key="journal.download"}
				</div>
				<div class="panel-body">
					{* Article Galleys *}
					{if $primaryGalleys || $supplementaryGalleys}
						<div class="download">
							{if $primaryGalleys}
								{foreach from=$primaryGalleys item=galley}
									{include file="frontend/objects/galley_link.tpl" parent=$article purchaseFee=$currentJournal->getSetting('purchaseArticleFee') purchaseCurrency=$currentJournal->getSetting('currency')}
								{/foreach}
							{/if}
							{if $supplementaryGalleys}
								{foreach from=$supplementaryGalleys item=galley}
									{include file="frontend/objects/galley_link.tpl" parent=$article isSupplementary="1"}
								{/foreach}
							{/if}
						</div>
					{/if}
				</div>
			</div>



			{* Stat *}
			{if $enableStatistic}
				<div class="panel panel-default galley_list">
					<div class="panel-heading">
						<i class="fa fa-bar-chart"> </i> {translate key="journal.statistic"}
					</div>
					<div class="panel-body">
						<div class=""> <span class="article_counter_read"> </span> {translate key="journal.read_counter"} :
							<b>{$article->getViews()} </b>
							{if $primaryGalleys}
								{assign var="galleysTotalView" value=0}
								{foreach from=$primaryGalleys item=galley name=galleyList}
									{assign var="galleysTotalView" value=$galleysTotalView+$galley->getViews()}
								{/foreach}
								<span class="pull-right">{translate key="journal.download"} : <b> {$galleysTotalView} </b> </span>
							{/if}

						</div>
						{call_hook name="Templates::Article::Main"}
					</div>
				</div>
			{/if}

			{* Stat *}
			{if $dimensionBadge}
				<div class="panel panel-default dimension_badge">
					<span class="__dimensions_badge_embed__" data-doi="{$article_doi|escape}" data-legend="always"
						data-style="small_circle"></span>
					<script async src="https://badge.dimensions.ai/badge.js" charset="utf-8"></script>
				</div>
			{/if}

			<div class="panel panel-default panel-tocs" style="display: none;" data-sticky-class="is-sticky"
				data-sticky-for="1023" data-margin-top="10">
				<div class="panel-heading">
					<i class="fa fa-list-ol" aria-hidden="true"></i> Table Of Contents
				</div>
				<div class="panel-body" id="article-navigation-menu-items" style="padding: 15px;">

				</div>
			</div>




		</section><!-- .article-sidebar -->

		<div class="col-md-8">
			<section class="article-main">

				{* Screen-reader heading for easier navigation jumps *}
				<h2 class="sr-only">{translate key="plugins.themes.academic_pro.article.main"}</h2>



				{* Article abstract *}
				{if $article->getLocalizedAbstract()}
					<div class="article-summary" id="summary">
						<h2>{translate key="article.abstract"}</h2>
						<div class="article-abstract">
							{$article->getLocalizedAbstract()|strip_unsafe_html|nl2br}
						</div>
					</div>
				{/if}


				{* Keywords *}
				{if !empty($publication->getLocalizedData('keywords'))}
					<div class="keywords">
						<h2 class="article-details-heading">
							{translate key="article.subject"}
						</h2>
						<div class="article-details-keywords-value">
							{foreach name="keywords" from=$publication->getLocalizedData('keywords') item="keyword"}
									<span class="keyword_item">{$keyword|escape}</span>
							{/foreach}
						</div>
					</div>

					<div class="clearfix"> </div>

				{/if}





			</section><!-- .article-main -->

			<section class="article-more-details">

				{* Screen-reader heading for easier navigation jumps *}
				<h2 class="sr-only">{translate key="plugins.themes.academic_pro.article.details"}</h2>


				{* PubIds (requires plugins) *}

				{* make compatible with ojs 3.1.2 *}
				{if $smarty_version == '2'}
					{include file="legacy/article_detail_pubs_3.1.1.tpl"}
				{else}
					{include file="legacy/article_detail_pubs_3.1.2.tpl"}
				{/if}
				{* end compatible check *}


				{* Article Subject *}
				{if $article->getLocalizedSubject()}
					<div class="panel panel-default subject">
						<div class="panel-heading">
							{translate key="article.subject"}
						</div>
						<div class="panel-body">
							{$article->getLocalizedSubject()|escape}
						</div>
					</div>
				{/if}




				{* Licensing info *}
				{if $currentContext->getLocalizedData('licenseTerms') || $publication->getData('licenseUrl')}
					<div class="panel panel-default copyright">
						<div class="panel-heading">
							<i class="fa fa-file-text-o"> </i>
							{translate key="submission.license"}
						</div>
						<div class="panel-body">
							{if $publication->getData('licenseUrl')}
								{if $ccLicenseBadge}
									{if $publication->getLocalizedData('copyrightHolder')}
										<p>
											{translate key="submission.copyrightStatement" copyrightHolder=$publication->getLocalizedData('copyrightHolder') copyrightYear=$publication->getData('copyrightYear')}
										</p>
									{/if}
									{$ccLicenseBadge}
								{else}
									<a href="{$publication->getData('licenseUrl')|escape}" class="copyright">
										{if $publication->getLocalizedData('copyrightHolder')}
											{translate key="submission.copyrightStatement" copyrightHolder=$publication->getLocalizedData('copyrightHolder') copyrightYear=$publication->getData('copyrightYear')}
										{else}
											{translate key="submission.license"}
										{/if}
									</a>
								{/if}
							{/if}
							{$currentContext->getLocalizedData('licenseTerms')}
						</div>
					</div>
				{/if}

				{* Author biographies *}
				{assign var="hasBiographies" value=0}
				{foreach from=$article->getAuthors() item=author}
					{if $author->getLocalizedBiography()}
						{assign var="hasBiographies" value=$hasBiographies+1}
					{/if}
				{/foreach}
				{if $hasBiographies}
					<div class="panel panel-default author-bios">
						<div class="panel-heading">

							{if $hasBiographies > 1}
								<i class="fa fa-users"> </i>{translate key="submission.authorBiographies"}
							{else}
								<i class="fa fa-user"> </i>{translate key="submission.authorBiography"}
							{/if}
						</div>
						<div class="panel-body">
							{foreach from=$article->getAuthors() item=author}
								{if $author->getLocalizedBiography()}
									<div class="media biography">
										<div class="media-body">
											<h3 class="media-heading biography-author">
												{if $author->getLocalizedAffiliation()}
													{capture assign="authorName"}{$author->getFullName()|escape}{/capture}
													{capture assign="authorAffiliation"}<span
														class="affiliation">{$author->getLocalizedAffiliation()|escape}</span>{/capture}
													{translate key="submission.authorWithAffiliation" name=$authorName affiliation=$authorAffiliation}
												{else}
													{$author->getFullName()|escape}
												{/if}
											</h3>
											{$author->getLocalizedBiography()|strip_unsafe_html}
										</div>
									</div>
								{/if}
							{/foreach}
						</div>
					</div>
				{/if}

				{* How to cite *}
				{if $citation}
					<div class="panel panel-default how-to-cite">
						<div class="panel-heading">
							<i class="fa fa-file-text"> </i> {translate key="submission.howToCite"}
						</div>
						<div class="panel-body">
							<div id="citationOutput" role="region" aria-live="polite">
								{$citation}
							</div>
							<div class="btn-group">
								<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"
									aria-controls="cslCitationFormats">
									{translate key="submission.howToCite.citationFormats"}
									<span class="caret"></span>
								</button>
								<ul class="dropdown-menu" role="menu">
									{foreach from=$citationStyles item="citationStyle"}
										<li>
											<a aria-controls="citationOutput"
												href="{url page="citationstylelanguage" op="get" path=$citationStyle.id params=$citationArgs}"
												data-load-citation
												data-json-href="{url page="citationstylelanguage" op="get" path=$citationStyle.id params=$citationArgsJson}">
												{$citationStyle.title|escape}
											</a>
										</li>
									{/foreach}
								</ul>
							</div>

							{if count($citationDownloads)}
								<div class="col-md-12 no-padding citation_download">
									<div class="title">
										{translate key="submission.howToCite.downloadCitation"}
									</div>
									{foreach from=$citationDownloads item="citationDownload"}
										<a class="dropdown-item"
											href="{url page="citationstylelanguage" op="download" path=$citationDownload.id params=$citationArgs}">
											{$citationDownload.title|escape}
										</a>
										<br>
									{/foreach}
								</div>
							{/if}

						</div>
					</div>
				{/if}

				<div class="panel panel-default XML_generated" style="display:none">
					<div class="panel-heading">
						<i class="fa fa-file-text"> </i>{translate	key="article.full_articles"}
					</div>
					<div class="panel-body jats_result">

					</div>
				</div>



				{call_hook name="Templates::Article::Details"}

				{* References *}
				{if $parsedCitations || $publication->getData('citationsRaw')}
					<div class="article-references">
						<h2><i class="fa fa-bookmark-o text-primary"> </i> {translate key="journal.references"} </h2>
						<div class="article-references-content value">
							<ol>
								{if $parsedCitations}
									{foreach from=$parsedCitations item="parsedCitation"}
										<li>{$parsedCitation->getCitationWithLinks()|strip_unsafe_html}
											{call_hook name="Templates::Article::Details::Reference" citation=$parsedCitation}</li>
									{/foreach}
								{else}
									{$publication->getData('citationsRaw')|escape|nl2br}
								{/if}
							</ol>
						</div>
					</div>
				{/if}



				{* References - For OAI-PMH (dialnet)*}
				{if $parsedCitations || $publication->getData('citationsRaw')}
					<div id="articleCitations" class="hidden">
						<h4> {translate key="journal.references"}</h4>
						<br>
						<div>
							{if $parsedCitations}
								{foreach from=$parsedCitations item="parsedCitation"}
									<p>{$parsedCitation->getCitationWithLinks()|strip_unsafe_html|trim}
										{call_hook name="Templates::Article::Details::Reference" citation=$parsedCitation}</p>
								{/foreach}
							{else}
								{$publication->getData('citationsRaw')|trim|escape|nl2br}
							{/if}
						</div>
					</div>
				{/if}

			</section><!-- .article-details -->
		</div><!-- .col-md-8 -->
	</div><!-- .row -->

</article>