{**
 * lib/pkp/templates/frontend/components/header.tpl
 *
  * Copyright (c) 2010-2020 openjournaltheme.com 
 * Copyright (c) 2010-2020 openjournaltheme team
 * Read this term of use of this theme here : https://openjournaltheme.com/term-of-conditions
 *
 * @brief Common frontend site header.
 *
 * @uses $isFullWidth bool Should this page be displayed without sidebars? This
 *       represents a page-level override, and doesn't indicate whether or not
 *       sidebars have been configured for thesite.
 * @uses $currentContext Journal|Press The current journal or press
 * @uses $author
 *}

{* Determine whether a logo or title string is being displayed *}
{assign var="showingLogo" value=true}


{if $displayPageHeaderTitle && !$displayPageHeaderLogo && is_string($displayPageHeaderTitle)}
	{assign var="showingLogo" value=false}
{/if}

<!DOCTYPE html>
<html lang="{$currentLocale|replace:"_":"-"}" xml:lang="{$currentLocale|replace:"_":"-"}">

{if !$prevent}
	{if !$pageTitleTranslated}{capture assign="pageTitleTranslated"}{translate key=$pageTitle}{/capture}{/if}
	{include file="frontend/components/headerHead.tpl" description=$description  }
{else}
	{$prevent}
{/if}


<body class="pkp_page_{$requestedPage|escape|default:"index"} pkp_op_{$requestedOp|escape|default:"index"}{if $showingLogo} has_site_logo{/if} {if $rtlMode}rtl{/if}">

	{if $isMaintenance}
	<div id="maintenance_container" style="position: relative; background: black; height: 30px">
		<!-- Other elements here -->
		<div id="maintenance_content" style="text-align:center; color: #DBB539; padding: 5px 0">
			<i class="fa fa-wrench"> </i> <a href="https://openjournaltheme.com" style="color: #DBB539; padding: 5px 0"> Site under upgrade process</a>			
		</div>
	</div>
	{/if}


	<div class="pkp_structure_page">

		<nav id="accessibility-nav" class="sr-only" role="navigation" aria-labelled-by="accessible-menu-label">
			<div id="accessible-menu-label">
				{translate|escape key="plugins.themes.academic_pro.accessible_menu.label"}
			</div>
			<ul>
			  <li><a href="#main-navigation">{translate|escape key="plugins.themes.academic_pro.accessible_menu.main_navigation"}</a></li>
			  <li><a href="#main-content">{translate|escape key="plugins.themes.academic_pro.accessible_menu.main_content"}</a></li>
			  <li><a href="#sidebar">{translate|escape key="plugins.themes.academic_pro.accessible_menu.sidebar"}</a></li>
			</ul>
		</nav>
		

		{* Header *}
		<header class="navbar navbar-default box-shadow background-white" id="headerNavigationContainer" role="banner">

			{* User profile, login, etc, navigation menu*}
			<div class="user_navigation">
			<div class="container">
				<div class="row">
				{* Mobile hamburger menu *}
					<button type="button" class="navbar-toggle collapsed pull-left" data-toggle="collapse" data-target="#nav-menu" aria-expanded="false" aria-controls="navbar">
						<span class="sr-only">Toggle navigation</span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
					</button>
					<nav aria-label="{translate|escape key="common.navigation.user"}" class="pull-right">
						{load_menu name="user" id="navigationUser" ulClass="nav nav-pills tab-list pull-right" linkClass="btn btn-info btn-sm"}
					</nav>
				</div><!-- .row -->
			</div><!-- .container-fluid -->
			</div>


			<div class="site_header">
			<div class="container">

				<div class="navbar-header  row display-flex">

					

					{* Logo or site title. Only use <h1> heading on the homepage.
					   Otherwise that should go to the page title. *}
					{if $requestedOp == 'index'}
						
						<h1 class="site-name ">
					{else}
						<div class="site-name">
					{/if}
					{capture assign="homeUrl"}
							{url page="index" router=$smarty.const.ROUTE_PAGE}
					{/capture}

						{if $displayPageHeaderLogo && is_array($displayPageHeaderLogo) && !$logoStyleBig}
							<span class="logo_small">
							<a href="{$homeUrl}"><img  src="{$publicFilesDir}/{$displayPageHeaderLogo.uploadName|escape:"url"}" {if $displayPageHeaderLogo.altText != ''}alt="{$displayPageHeaderLogo.altText|escape}"{else}alt="{translate key="common.pageHeaderLogo.altText"}"{/if}></a>					
							</span>
						{/if}
					
						{if $displayPageHeaderTitle  && is_string($displayPageHeaderTitle)}
							<a href="{$homeUrl}" class="navbar-brand">{$displayPageHeaderTitle}</a>
						{elseif $displayPageHeaderTitle && is_array($displayPageHeaderTitle)}
							<a href="{$homeUrl}" class="navbar-brand">{$siteTitle}</a>
						{else}
							<a href="{$homeUrl}" class="navbar-brand">
								OJS Site Name
							</a>
						{/if}
					{if $requestedOp == 'index'}
						</h1>
					{else}
						</div>
					{/if}

				</div>

				{* Primary site navigation *}
				{capture assign="primaryMenu"}
					{load_menu name="primary" id="main-navigation" ulClass="nav navbar-nav"}
				{/capture}

				{if !empty(trim($primaryMenu)) || !$noContextsConfigured}
					<nav id="nav-menu" class="navbar-collapse collapse" aria-label="{translate|escape key="common.navigation.site"}">
						{* Primary navigation menu for current application *}
						{$primaryMenu}

						{* Search form *}
						{if !$noContextsConfigured}
							<div class="pull-md-right search_input">
								{include file="frontend/components/searchForm_simple.tpl"}
							</div>
						{/if}
					</nav>
				{/if}

			</div><!-- .pkp_head_wrapper -->

			</div>


			<div class="header_shadow"></div>


		</header><!-- .pkp_structure_head -->



		<div class="row journal_index header_section">


			<div class="container journal_name_logo ">
				<div class="col-md-5 site_logo">
				
					
					{* Show site Logo *}
					{if $displayPageHeaderLogo && is_array($displayPageHeaderLogo) && $logoStyleBig}
					<img  src="{$publicFilesDir}/{$displayPageHeaderLogo.uploadName|escape:"url"}" {if $displayPageHeaderLogo.altText != ''}alt="{$displayPageHeaderLogo.altText|escape}"{else}alt="{translate key="common.pageHeaderLogo.altText"}"{/if}>					
					{/if}
				</div>	
				
				{if $about}
				<div class="col-md-6 site_description ">
							
								<div class="about_site">
									{$about|nl2br}
								</div>
						
				</div>	
				{/if}

			</div>	



			{if $currentContext }
				<div class="container journal_name_logo ">
					<div class="col-md-12 about_journal">
						<h1>{translate key="journal.about"} </h1>
						<p>
						{$currentContext->getLocalizedSetting('about')}
						</p>
					</div>
				</div>
			{/if}



		</div>	
{* Wrapper for page content and sidebars *}
		<div class="pkp_structure_content container main_content">
			<main class="pkp_structure_main col-xs-12 col-sm-7 {if ($isFullWidth)} col-md-12 {else}  col-md-8 {/if} " role="main">

		




		