<?php

import('pages.article.ArticleHandler');

class FullTextArticleHandler extends ArticleHandler
{
	/**
	 * Constructor
	 */
	function __construct()
	{
		parent::__construct();
	}

	/**
	 * @param $args
	 * @param $request
	 * @brief download supplementary files for article's full-text
	 */
	function downloadFullTextAssoc($args, $request)
	{
		$fileId = $args[2];
		$dispatcher = $request->getDispatcher();
		if (empty($fileId) || !$this->article || !$this->publication) $dispatcher->handle404();

		if (!$this->userCanViewGalley($request, $this->article->getId())) {
			header('HTTP/1.0 403 Forbidden');
			echo '403 Forbidden<br>';
			exit;
		}

		$submissionFileDao = &DAORegistry::getDAO('SubmissionFileDAO');
		$submissionFile = $submissionFileDao->getById($fileId);

		if (!$submissionFile) $dispatcher->handle404();

		if (!in_array($submissionFile->getData('mimetype'), ['image/png', 'image/jpeg'])) $dispatcher->handler404();

		// Download file if exists
		if (!Services::get('file')->fs->has($submissionFile->getData('path'))) {
			$request->getDispatcher()->handle404();
		}

		$filename = Services::get('file')->formatFilename($submissionFile->getData('path'), $submissionFile->getLocalizedData('name'));
		Services::get('file')->download($submissionFile->getData('fileId'), $filename);
	}
}
